/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.digital_adapter.DigitalAdapterTileEntity;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorTileEntity;
import com.mrh0.createaddition.compat.computercraft.Helpers;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.MechanicalBearingTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.pulley.PulleyTileEntity;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyTileEntity;
import com.simibubi.create.content.contraptions.relays.gauge.SpeedGaugeTileEntity;
import com.simibubi.create.content.contraptions.relays.gauge.StressGaugeTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DigitalAdapterPeripheral
implements IPeripheral {
    private final String type;
    private final DigitalAdapterTileEntity tileEntity;

    public DigitalAdapterPeripheral(String type, DigitalAdapterTileEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @Nullable
    public Object getTarget() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final void clearLine() {
        this.tileEntity.clearLine(this.tileEntity.getLine());
    }

    @LuaFunction(mainThread=true)
    public final void clear() {
        this.tileEntity.clearAll();
    }

    @LuaFunction(mainThread=true)
    public final void print(String text) {
        this.tileEntity.setTextLine(this.tileEntity.getLine(), (MutableComponent)new TextComponent(text.substring(0, Math.min(text.length(), 128))));
        this.tileEntity.incrementLine();
    }

    @LuaFunction(mainThread=true)
    public final int getLine() {
        return this.tileEntity.getLine();
    }

    @LuaFunction(mainThread=true)
    public final int setLine(int ln) {
        return this.tileEntity.setLine(ln);
    }

    @LuaFunction(mainThread=true)
    public final int getMaxLines() {
        return 16;
    }

    @LuaFunction(mainThread=true)
    public final void setTargetSpeed(String direction, int speed) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return;
        }
        this.tileEntity.setTargetSpeed(dir, speed);
    }

    @LuaFunction(mainThread=true)
    public final int getTargetSpeed(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        return this.tileEntity.getTargetSpeed(dir);
    }

    @LuaFunction(mainThread=true)
    public final int getKineticStress(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        StressGaugeTileEntity sg = this.tileEntity.getStressGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getNetworkStress();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticCapacity(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        StressGaugeTileEntity sg = this.tileEntity.getStressGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getNetworkCapacity();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticSpeed(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        SpeedGaugeTileEntity sg = this.tileEntity.getSpeedGauge(dir);
        if (sg == null) {
            return 0;
        }
        return (int)sg.getSpeed();
    }

    @LuaFunction(mainThread=true)
    public final int getKineticTopSpeed() {
        return (Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get();
    }

    @LuaFunction(mainThread=true)
    public final int getPulleyDistance(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        PulleyTileEntity rp = this.tileEntity.getRopePulley(dir);
        HosePulleyTileEntity hp = this.tileEntity.getHosePulley(dir);
        if (rp != null) {
            return (int)rp.getInterpolatedOffset(0.5f);
        }
        if (hp != null) {
            return (int)hp.getInterpolatedOffset(0.5f);
        }
        return 0;
    }

    @LuaFunction(mainThread=true)
    public final int getPistonDistance(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        MechanicalPistonTileEntity mp = this.tileEntity.getMechanicalPiston(dir);
        if (mp == null) {
            return 0;
        }
        return (int)mp.getInterpolatedOffset(0.5f);
    }

    @LuaFunction(mainThread=true)
    public final int getBearingAngle(String direction) {
        Direction dir = Helpers.nameToDir(direction);
        if (dir == null) {
            return 0;
        }
        MechanicalBearingTileEntity mp = this.tileEntity.getMechanicalBearing(dir);
        if (mp == null) {
            return 0;
        }
        return (int)mp.getInterpolatedAngle(0.5f);
    }

    @LuaFunction(mainThread=true)
    public final float getDurationAngle(int deg, int rpm) throws LuaException {
        return (float)ElectricMotorTileEntity.getDurationAngle(deg, 0.0f, rpm) / 20.0f;
    }

    @LuaFunction(mainThread=true)
    public final float getDurationDistance(int blocks, int rpm) throws LuaException {
        return (float)ElectricMotorTileEntity.getDurationDistance(blocks, 0.0f, rpm) / 20.0f;
    }
}

